/* Game music emulator C interface */

/* Game_Music_Emu 0.4.0 */
#ifndef GME_H
#define GME_H

#ifdef __cplusplus
	extern "C" {
#endif

/* Emulator type constants */
extern struct gme_type_t_ const gme_nsf_type [], gme_nsfe_type [], gme_gbs_type [],
		gme_vgm_type [], gme_gym_type [], gme_spc_type [];
typedef struct gme_type_t_ const* gme_type_t;

/* Functions that can fail return a const char* error string or NULL on success.
Functions taking data,size accept either a path to a file (pass 0 for size) or
a pointer and size of file data in memory (functions make a copy of data) */

/* Get track info for file without having to load it into an emulator */
typedef struct track_info_t track_info_t;
const char* gme_read_track_info( gme_type_t, track_info_t* out, int track,
		const char* data, long size );

/* 1. Create emulator */
typedef struct Music_Emu Music_Emu;
Music_Emu* gme_new_emu( gme_type_t, long sample_rate );

/* 2. Load music file */
const char* gme_load_file( Music_Emu*, const char* data, long size );

/* 3. Get track info (optional) */
int gme_track_count( Music_Emu const* );
const char* gme_track_info( Music_Emu*, track_info_t* out, int track );

/* 4. Start a track and optionally set fade time */
void gme_start_track( Music_Emu*, int index );
void gme_set_fade( Music_Emu*, long start_msec );

/* 5. Generate samples as needed (output is in stereo) */
void gme_play( Music_Emu*, long sample_count, short* out );

/* 6. Check track status and elapsed time, or seek to a new position (optional) */
int  gme_track_ended( Music_Emu const* );
long gme_tell( Music_Emu const* );
void gme_seek( Music_Emu*, long msec );

/* 7. Go back to step 2 or 4, or finish using emulator and free memory */
void gme_delete( Music_Emu* );

struct track_info_t
{
	int track_count;
	
	/* times in milliseconds; -1 if unknown */
	long length;
	long intro_length;
	long loop_length;
	
	/* empty string if not available */
	char game      [256];
	char song      [256];
	char author    [256];
	char copyright [256];
	char comment   [256];
	char dumper    [256];
	char system    [256];
	
#ifdef __cplusplus
	enum { max_field = 255 };
	void init();
	static void copy_field( char* out, const char* in );
	static void copy_field( char* out, const char* in, int len );
	static const char* error() { return 0; }
#endif
};

#ifdef __cplusplus
	}
#endif

#endif
